/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.impl.io.DirRandomAccessFile4;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile4
extends DirFile {
    private RandomAccessFile lockFileOpen;
    private FileChannel lockFileChannel;
    private FileLock dbLock;
    private final boolean rwsOK;

    public StorageFile getParentDir() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new DirFile4(string, this.rwsOK);
    }

    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        return new FileOutputStream(this, bl);
    }

    public synchronized int getExclusiveFileLock() {
        int n;
        boolean bl = false;
        try {
            if (this.createNewFile()) {
                bl = true;
            } else if (this.length() > 0L) {
                bl = true;
            }
            if (bl) {
                this.lockFileOpen = new RandomAccessFile(this, "rw");
                this.lockFileChannel = this.lockFileOpen.getChannel();
                this.dbLock = this.lockFileChannel.tryLock();
                if (this.dbLock == null) {
                    this.lockFileChannel.close();
                    this.lockFileChannel = null;
                    this.lockFileOpen.close();
                    this.lockFileOpen = null;
                    n = 2;
                } else {
                    this.lockFileOpen.writeInt(1);
                    this.lockFileChannel.force(true);
                    n = 1;
                }
            } else {
                n = 0;
            }
        }
        catch (IOException iOException) {
            this.releaseExclusiveFileLock();
            n = 0;
        }
        return n;
    }

    public synchronized void releaseExclusiveFileLock() {
        try {
            if (this.dbLock != null) {
                this.dbLock.release();
                this.dbLock = null;
            }
            if (this.lockFileChannel != null) {
                this.lockFileChannel.close();
                this.lockFileChannel = null;
            }
            if (this.lockFileOpen != null) {
                this.lockFileOpen.close();
                this.lockFileOpen = null;
            }
            super.releaseExclusiveFileLock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        if (!this.rwsOK && "rws".equals(string) || "rwd".equals(string)) {
            string = "rw";
        }
        return new DirRandomAccessFile4(this, string);
    }

    DirFile4(String string, boolean bl) {
        super(string);
        this.rwsOK = bl;
    }

    DirFile4(String string, String string2, boolean bl) {
        super(string, string2);
        this.rwsOK = bl;
    }

    DirFile4(DirFile dirFile, String string, boolean bl) {
        super(dirFile, string);
        this.rwsOK = bl;
    }
}

